/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.client.column;

import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.Configuration;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.server.ColumnDefinitionPacket;

public class UnsignedBigIntColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public UnsignedBigIntColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return BigInteger.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -5;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "BIGINT UNSIGNED";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return new BigInteger(buf.readAscii(length));
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, int length) throws SQLDataException {
        String s = buf.readAscii(length);
        return !"0".equals(s);
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readLong() != 0L;
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.atoull(length);
        if ((long)((byte)result) != result || result < 0L) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        BigInteger val = new BigInteger(1, bb);
        try {
            return val.byteValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{val, this.dataType}));
        }
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return buf.readString(length);
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb).toString();
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.atoull(length);
        if ((long)((short)result) != result || result < 0L) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.readLong();
        if ((long)((short)result) != result || result < 0L) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.atoull(length);
        int res = (int)result;
        if ((long)res != result || result < 0L) {
            throw new SQLDataException("integer overflow");
        }
        return res;
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        BigInteger val = new BigInteger(1, bb);
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException ae) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", val));
        }
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, int length) throws SQLDataException {
        if (length < 10) {
            return buf.atoull(length);
        }
        BigInteger val = new BigInteger(buf.readAscii(length));
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException ae) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", val));
        }
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        if ((buf.getByte(buf.pos() + 7) & 0x80) == 0) {
            return buf.readLong();
        }
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        BigInteger val = new BigInteger(1, bb);
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException ae) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", val));
        }
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, int length) throws SQLDataException {
        return Float.parseFloat(buf.readAscii(length));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb).floatValue();
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, int length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        byte[] bb = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bb[i] = buf.readByte();
        }
        return new BigInteger(1, bb).doubleValue();
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

